<?php
// Run this file to migrate the database for contact phone support
// Access via: php Backend/migrate_contact_phone.php

require_once __DIR__ . '/config/Database.php';

try {
    $database = new Config\Database();
    $conn = $database->getConnection();
    
    echo "Starting database migration for contact phone support...\n\n";
    
    // Check if column exists
    $stmt = $conn->prepare("SHOW COLUMNS FROM contacts LIKE 'phone'");
    $stmt->execute();
    
    if ($stmt->rowCount() == 0) {
        echo "Adding phone column to contacts table...\n";
        $conn->exec("ALTER TABLE contacts ADD COLUMN phone VARCHAR(20) AFTER email");
        echo "✓ Contacts table updated\n\n";
    } else {
        echo "Phone column already exists.\n\n";
    }
    
    echo "Migration completed successfully!\n";
    
} catch (Exception $e) {
    echo "Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
