<?php
// Run this file to migrate the database for base64 image support
// Access via: php Backend/migrate_db.php

require_once __DIR__ . '/config/Database.php';

try {
    $database = new Config\Database();
    $conn = $database->getConnection();
    
    echo "Starting database migration for base64 image support...\n\n";
    
    // Update products table
    echo "Updating products table...\n";
    $conn->exec("ALTER TABLE products MODIFY COLUMN image_url LONGTEXT");
    echo "✓ Products table updated\n\n";
    
    // Update categories table
    echo "Updating categories table...\n";
    $conn->exec("ALTER TABLE categories MODIFY COLUMN image_url LONGTEXT");
    echo "✓ Categories table updated\n\n";
    
    echo "Migration completed successfully!\n";
    echo "You can now use base64 images in your products and categories.\n";
    
} catch (Exception $e) {
    echo "Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
