<?php
// Handle CORS
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET,POST,PUT,DELETE");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Simple Autoloader
spl_autoload_register(function ($class) {
    if (strpos($class, 'Config\\') === 0) {
        require_once __DIR__ . '/../config/' . substr($class, 7) . '.php';
    } elseif (strpos($class, 'App\\Core\\') === 0) {
        require_once __DIR__ . '/../src/Core/' . substr($class, 9) . '.php';
    } elseif (strpos($class, 'App\\Controllers\\') === 0) {
        require_once __DIR__ . '/../src/Controllers/' . substr($class, 16) . '.php';
    } elseif (strpos($class, 'App\\Models\\') === 0) {
        require_once __DIR__ . '/../src/Models/' . substr($class, 11) . '.php';
    }
});

use App\Core\Router;
use App\Controllers\ProductController;
use App\Controllers\CategoryController;
use App\Controllers\OrderController;
use App\Controllers\TestController;

$router = new Router();

// Define Routes
$router->get('/test', [TestController::class, 'index']);
$router->get('/products', [ProductController::class, 'getAll']);
$router->get('/product', [ProductController::class, 'getById']);
$router->get('/categories', [CategoryController::class, 'getAll']);

// Order Routes
$router->post('/orders', [OrderController::class, 'create']);
$router->get('/orders', [OrderController::class, 'getAll']);
$router->get('/order', [OrderController::class, 'getById']); // Single order endpoint
$router->post('/orders/status', [OrderController::class, 'updateStatus']); // Using POST for update to avoid simple router PUT issues
$router->post('/orders/delete', [OrderController::class, 'delete']); // Using POST for delete for simplicity

// Product CRUD Routes
$router->post('/products/create', [ProductController::class, 'create']);
$router->post('/products/update', [ProductController::class, 'update']);
$router->post('/products/delete', [ProductController::class, 'delete']);

// Category Routes
$router->post('/categories/create', [CategoryController::class, 'create']);

// Stats Route
use App\Controllers\StatsController;
$router->get('/stats/overview', [StatsController::class, 'getOverview']);

// Analytics Route
use App\Controllers\AnalyticsController;
$router->get('/analytics', [AnalyticsController::class, 'getAnalytics']);

// Contact/Message Routes
use App\Controllers\ContactController;
$router->post('/contact', [ContactController::class, 'create']);
$router->get('/messages', [ContactController::class, 'getAll']);
$router->get('/message', [ContactController::class, 'getById']);
$router->post('/messages/read', [ContactController::class, 'markAsRead']);
$router->post('/messages/delete', [ContactController::class, 'delete']);
$router->get('/messages/stats', [ContactController::class, 'getStats']);

// Dispatch
$router->dispatch();
