<?php
namespace App\Controllers;

use App\Models\Category;

class CategoryController {
    public function getAll() {
        $category = new Category();
        $stmt = $category->read();
        $num = $stmt->rowCount();

        if($num > 0) {
            $categories_arr = array();
            $categories_arr["data"] = array();

            while ($row = $stmt->fetch(\PDO::FETCH_ASSOC)){
                extract($row);
                $category_item = array(
                    "id" => $id,
                    "name" => $name,
                    "slug" => $slug,
                    "description" => $description,
                    "image_url" => $image_url
                );
                array_push($categories_arr["data"], $category_item);
            }
            echo json_encode($categories_arr);
        } else {
            echo json_encode(array("data" => array()));
        }
    }

    public function create() {
        try {
            $data = json_decode(file_get_contents("php://input"), true);
            
            if (!isset($data['name'])) {
                http_response_code(400);
                echo json_encode(array("message" => "Category name is required."));
                return;
            }

            $category = new Category();
            if ($category->create($data)) {
                http_response_code(201);
                echo json_encode(array("message" => "Category created successfully."));
            } else {
                http_response_code(503);
                echo json_encode(array("message" => "Unable to create category."));
            }
        } catch (\Exception $e) {
            http_response_code(500);
            echo json_encode(array("message" => "Failed to create category.", "error" => $e->getMessage()));
        }
    }
}
