<?php
namespace App\Controllers;

use App\Models\Contact;

class ContactController {
    public function create() {
        $data = json_decode(file_get_contents("php://input"));

        if (!empty($data->name) && !empty($data->email) && !empty($data->message)) {
            $contact = new Contact();
            $contact->name = $data->name;
            $contact->email = $data->email;
            $contact->phone = isset($data->phone) ? $data->phone : '';
            $contact->subject = isset($data->subject) ? $data->subject : 'No Subject';
            $contact->message = $data->message;

            if ($contact->create()) {
                http_response_code(201);
                echo json_encode(["message" => "Message sent successfully."]);
            } else {
                http_response_code(503);
                echo json_encode(["message" => "Unable to send message."]);
            }
        } else {
            http_response_code(400);
            echo json_encode(["message" => "Incomplete data. Name, email and message are required."]);
        }
    }

    public function getAll() {
        $contact = new Contact();
        $result = $contact->getAll();
        
        // Ensure result is always an array
        if (!$result) {
            $result = [];
        }
        
        echo json_encode(["data" => $result]);
    }

    public function getById() {
        if (isset($_GET['id'])) {
            $contact = new Contact();
            $result = $contact->getById($_GET['id']);
            
            if ($result) {
                echo json_encode(["data" => $result]);
            } else {
                http_response_code(404);
                echo json_encode(["message" => "Message not found."]);
            }
        } else {
            http_response_code(400);
            echo json_encode(["message" => "ID is required."]);
        }
    }
    
    public function markAsRead() {
        $data = json_decode(file_get_contents("php://input"));
        
        if (!empty($data->id)) {
            $contact = new Contact();
            if ($contact->markAsRead($data->id)) {
                echo json_encode(["message" => "Message marked as read."]);
            } else {
                http_response_code(503);
                echo json_encode(["message" => "Unable to update message."]);
            }
        } else {
            http_response_code(400);
            echo json_encode(["message" => "ID is required."]);
        }
    }

    public function delete() {
        $data = json_decode(file_get_contents("php://input"));
        
        if (!empty($data->id)) {
            $contact = new Contact();
            if ($contact->delete($data->id)) {
                echo json_encode(["message" => "Message deleted."]);
            } else {
                http_response_code(503);
                echo json_encode(["message" => "Unable to delete message."]);
            }
        } else {
            http_response_code(400);
            echo json_encode(["message" => "ID is required."]);
        }
    }
    
    public function getStats() {
        $contact = new Contact();
        $unread = $contact->getUnreadCount();
        echo json_encode(["unread" => $unread]);
    }
}
