<?php
namespace App\Controllers;

use App\Models\Order;

class OrderController {
    
    public function create() {
        try {
            $data = json_decode(file_get_contents("php://input"), true);
            
            // Log incoming data for debugging
            error_log("Order creation attempt: " . json_encode($data));
            
            // Basic Validation
            if (!isset($data['customer_name']) || !isset($data['items']) || empty($data['items'])) {
                http_response_code(400);
                echo json_encode(["message" => "Incomplete data. Name and Items are required."]);
                return;
            }

            $order = new Order();
            $result = $order->create($data);

            if ($result['status']) {
                http_response_code(201);
                echo json_encode(["message" => "Order placed successfully.", "order_number" => $result['order_number']]);
            } else {
                http_response_code(503);
                error_log("Order creation failed: " . $result['message']);
                echo json_encode(["message" => "Unable to place order.", "error" => $result['message']]);
            }
        } catch (\Exception $e) {
            http_response_code(503);
            error_log("Order creation exception: " . $e->getMessage());
            echo json_encode(["message" => "Unable to place order.", "error" => $e->getMessage()]);
        }
    }

    public function getAll() {
        try {
            $order = new Order();
            $orders = $order->getAll();
            echo json_encode(["data" => $orders]);
        } catch (\Exception $e) {
            http_response_code(503);
            echo json_encode(["message" => "Unable to fetch orders.", "error" => $e->getMessage()]);
        }
    }

    public function updateStatus() {
        $data = json_decode(file_get_contents("php://input"), true);
        
        if (!isset($data['id']) || !isset($data['status'])) {
            http_response_code(400);
            echo json_encode(["message" => "ID and Status are required."]);
            return;
        }

        $order = new Order();
        if ($order->updateStatus($data['id'], $data['status'])) {
            echo json_encode(["message" => "Order status updated."]);
        } else {
            http_response_code(503);
            echo json_encode(["message" => "Unable to update status."]);
        }
    }

    public function getById() {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(["message" => "Order ID is required."]);
            return;
        }

        $order = new Order();
        $result = $order->getById($id);

        if ($result) {
            echo json_encode(["data" => $result]);
        } else {
            http_response_code(404);
            echo json_encode(["message" => "Order not found."]);
        }
    }

    public function delete() {
        // For DELETE requests, usually params come from URL or Query string in simple routers
        // Or specific input body. Let's assume input body for simplicity or $_GET['id'] if simple router supports it.
        // Our simple router might not parse params from URL like /orders/1
        // So we'll use a POST/DELETE method with body or query param
        
        $data = json_decode(file_get_contents("php://input"), true);
         // Fallback to query param if body is empty (common in some setups)
        $id = $data['id'] ?? $_GET['id'] ?? null;

        if (!$id) {
            http_response_code(400);
            echo json_encode(["message" => "ID is required."]);
            return;
        }

        $order = new Order();
        if ($order->delete($id)) {
            echo json_encode(["message" => "Order deleted."]);
        } else {
            http_response_code(503);
            echo json_encode(["message" => "Unable to delete order."]);
        }
    }
}
