<?php
namespace App\Controllers;

use App\Models\Product;

class ProductController {
    public function getAll() {
        try {
            $product = new Product();
            $stmt = $product->read();
            $num = $stmt->rowCount();

            if($num > 0) {
                $products_arr = array();
                $products_arr["data"] = array();

                while ($row = $stmt->fetch(\PDO::FETCH_ASSOC)){
                    extract($row);
                    $product_item = array(
                        "id" => $id,
                        "category_id" => $category_id,
                        "name" => $name,
                        "slug" => $slug,
                        "description" => html_entity_decode($description),
                        "price" => $price,
                        "stock_quantity" => $stock_quantity,
                        "category_name" => $category_name,
                        "image_url" => $image_url,
                        "is_featured" => $is_featured
                    );
                    array_push($products_arr["data"], $product_item);
                }
                echo json_encode($products_arr);
            } else {
                echo json_encode(array("data" => []));
            }
        } catch (\Exception $e) {
            http_response_code(500);
            echo json_encode(array("message" => "Failed to fetch products.", "error" => $e->getMessage()));
        }
    }

    public function getById() {
        try {
            $id = $_GET['id'] ?? null;
            
            if (!$id) {
                http_response_code(400);
                echo json_encode(array("message" => "Product ID is required."));
                return;
            }

            $product = new Product();
            $row = $product->getById($id);

            if($row) {
                extract($row);
                $product_item = array(
                    "id" => $id,
                    "category_id" => $category_id,
                    "name" => $name,
                    "slug" => $slug,
                    "description" => html_entity_decode($description),
                    "price" => $price,
                    "stock_quantity" => $stock_quantity,
                    "category_name" => $category_name,
                    "image_url" => $image_url,
                    "is_featured" => $is_featured
                );
                echo json_encode($product_item);
            } else {
                http_response_code(404);
                echo json_encode(array("message" => "Product not found."));
            }
        } catch (\Exception $e) {
            http_response_code(500);
            echo json_encode(array("message" => "Failed to fetch product.", "error" => $e->getMessage()));
        }
    }

    public function create() {
        try {
            $data = json_decode(file_get_contents("php://input"), true);
            
            // Validation
            if (!isset($data['name']) || !isset($data['price'])) {
                http_response_code(400);
                echo json_encode(array("message" => "Name and price are required."));
                return;
            }

            // Set defaults
            if (!isset($data['category_id'])) $data['category_id'] = null;
            if (!isset($data['description'])) $data['description'] = '';
            if (!isset($data['stock_quantity'])) $data['stock_quantity'] = 0;
            if (!isset($data['image_url'])) $data['image_url'] = '';
            if (!isset($data['is_featured'])) $data['is_featured'] = 0;

            $product = new Product();
            if ($product->create($data)) {
                http_response_code(201);
                echo json_encode(array("message" => "Product created successfully."));
            } else {
                http_response_code(503);
                echo json_encode(array("message" => "Unable to create product."));
            }
        } catch (\Exception $e) {
            http_response_code(500);
            echo json_encode(array("message" => "Failed to create product.", "error" => $e->getMessage()));
        }
    }

    public function update() {
        try {
            $data = json_decode(file_get_contents("php://input"), true);
            
            if (!isset($data['id'])) {
                http_response_code(400);
                echo json_encode(array("message" => "Product ID is required."));
                return;
            }

            $product = new Product();
            if ($product->update($data['id'], $data)) {
                echo json_encode(array("message" => "Product updated successfully."));
            } else {
                http_response_code(503);
                echo json_encode(array("message" => "Unable to update product."));
            }
        } catch (\Exception $e) {
            http_response_code(500);
            echo json_encode(array("message" => "Failed to update product.", "error" => $e->getMessage()));
        }
    }

    public function delete() {
        try {
            $data = json_decode(file_get_contents("php://input"), true);
            $id = $data['id'] ?? $_GET['id'] ?? null;

            if (!$id) {
                http_response_code(400);
                echo json_encode(array("message" => "Product ID is required."));
                return;
            }

            $product = new Product();
            if ($product->delete($id)) {
                echo json_encode(array("message" => "Product deleted successfully."));
            } else {
                http_response_code(503);
                echo json_encode(array("message" => "Unable to delete product."));
            }
        } catch (\Exception $e) {
            http_response_code(500);
            echo json_encode(array("message" => "Failed to delete product.", "error" => $e->getMessage()));
        }
    }
}
