<?php
namespace App\Controllers;

use App\Models\Order;
use App\Models\Product;
use Config\Database;

class StatsController {
    private $db;

    public function __construct() {
        $database = new Database();
        $this->db = $database->getConnection();
    }

    public function getOverview() {
        // 1. Total Revenue (Sum of total_amount from orders where status != cancelled)
        $queryRevenue = "SELECT SUM(total_amount) as total FROM orders WHERE status != 'cancelled'";
        $stmtRevenue = $this->db->prepare($queryRevenue);
        $stmtRevenue->execute();
        $revenue = $stmtRevenue->fetch(\PDO::FETCH_ASSOC)['total'] ?? 0;

        // 2. Active Orders (status = pending or processing)
        $queryActive = "SELECT COUNT(*) as count FROM orders WHERE status IN ('pending', 'processing')";
        $stmtActive = $this->db->prepare($queryActive);
        $stmtActive->execute();
        $activeOrders = $stmtActive->fetch(\PDO::FETCH_ASSOC)['count'] ?? 0;

        // 3. Total Customers (Unique emails in orders table)
        // Note: Ideally users table, but generic e-commerce often counts unique guest emails as customers if no auth
        $queryCustomers = "SELECT COUNT(DISTINCT customer_email) as count FROM orders";
        $stmtCustomers = $this->db->prepare($queryCustomers);
        $stmtCustomers->execute();
        $customers = $stmtCustomers->fetch(\PDO::FETCH_ASSOC)['count'] ?? 0;

        // 4. Total Products
        $queryProducts = "SELECT COUNT(*) as count FROM products";
        $stmtProducts = $this->db->prepare($queryProducts);
        $stmtProducts->execute();
        $products = $stmtProducts->fetch(\PDO::FETCH_ASSOC)['count'] ?? 0;

        echo json_encode([
            "revenue" => $revenue,
            "active_orders" => $activeOrders,
            "total_customers" => $customers,
            "total_products" => $products
        ]);
    }
}
