<?php
namespace App\Core;

class Router {
    private $routes = [];

    public function get($path, $callback) {
        $this->routes['GET'][$path] = $callback;
    }

    public function post($path, $callback) {
        $this->routes['POST'][$path] = $callback;
    }

    public function dispatch() {
        $method = $_SERVER['REQUEST_METHOD'];
        $path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        
        // Remove /api prefix if present (accounting for subdirectories if needed)
        // For local dev, assumption is index.php handles everything, so we look relative to scriptname or just strip known prefixes
        // Simplification: We assume the server points /api requests here. Let's normalize.
        // If URI is /Backend/public/index.php/products -> we want /products
        
        $scriptName = dirname($_SERVER['SCRIPT_NAME']);
        if ($scriptName !== '/' && strpos($path, $scriptName) === 0) {
            $path = substr($path, strlen($scriptName));
        }
        
        // Further implementation for clean URLs usually handled by .htaccess to index.php
        // Let's assume standard index.php routing
        
        if (isset($this->routes[$method][$path])) {
            $callback = $this->routes[$method][$path];
            
            if (is_array($callback)) {
                $controller = new $callback[0]();
                $method = $callback[1];
                return $controller->$method();
            }
            
            return call_user_func($callback);
        }

        // 404
        header("HTTP/1.0 404 Not Found");
        echo json_encode(['error' => 'Not Found']);
    }
}
