<?php
namespace App\Models;

use Config\Database;

class Category {
    private $conn;
    private $table_name = "categories";

    public function __construct() {
        $database = new Database();
        $this->conn = $database->getConnection();
    }

    public function read() {
        $query = "SELECT id, name, description, image_url, slug FROM " . $this->table_name;
        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function create($data) {
        $query = "INSERT INTO " . $this->table_name . " 
                (name, slug, description, image_url)
                VALUES (:name, :slug, :description, :image_url)";
        
        $stmt = $this->conn->prepare($query);
        
        // Generate slug from name if not provided
        $slug = isset($data['slug']) ? $data['slug'] : strtolower(str_replace(' ', '-', $data['name']));
        $description = isset($data['description']) ? $data['description'] : '';
        $image_url = isset($data['image_url']) ? $data['image_url'] : '';
        
        $stmt->bindParam(":name", $data['name']);
        $stmt->bindParam(":slug", $slug);
        $stmt->bindParam(":description", $description);
        $stmt->bindParam(":image_url", $image_url);
        
        return $stmt->execute();
    }
}
