<?php
namespace App\Models;

use Config\Database;

class Product {
    private $conn;
    private $table_name = "products";

    public function __construct() {
        $database = new Database();
        $this->conn = $database->getConnection();
    }

    public function read() {
        $query = "SELECT p.*, c.name as category_name 
                  FROM " . $this->table_name . " p
                  LEFT JOIN categories c ON p.category_id = c.id
                  ORDER BY p.created_at DESC";

        $stmt = $this->conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function create($data) {
        $query = "INSERT INTO " . $this->table_name . " 
                (category_id, name, slug, description, price, stock_quantity, image_url, is_featured)
                VALUES (:category_id, :name, :slug, :description, :price, :stock_quantity, :image_url, :is_featured)";
        
        $stmt = $this->conn->prepare($query);
        
        // Generate slug from name if not provided
        $slug = isset($data['slug']) ? $data['slug'] : strtolower(str_replace(' ', '-', $data['name']));
        
        $stmt->bindParam(":category_id", $data['category_id']);
        $stmt->bindParam(":name", $data['name']);
        $stmt->bindParam(":slug", $slug);
        $stmt->bindParam(":description", $data['description']);
        $stmt->bindParam(":price", $data['price']);
        $stmt->bindParam(":stock_quantity", $data['stock_quantity']);
        $stmt->bindParam(":image_url", $data['image_url']);
        $stmt->bindParam(":is_featured", $data['is_featured']);
        
        return $stmt->execute();
    }

    public function update($id, $data) {
        $query = "UPDATE " . $this->table_name . " 
                SET category_id = :category_id,
                    name = :name,
                    slug = :slug,
                    description = :description,
                    price = :price,
                    stock_quantity = :stock_quantity,
                    image_url = :image_url,
                    is_featured = :is_featured
                WHERE id = :id";
        
        $stmt = $this->conn->prepare($query);
        
        // Generate slug from name if not provided
        $slug = isset($data['slug']) ? $data['slug'] : strtolower(str_replace(' ', '-', $data['name']));
        
        $stmt->bindParam(":id", $id);
        $stmt->bindParam(":category_id", $data['category_id']);
        $stmt->bindParam(":name", $data['name']);
        $stmt->bindParam(":slug", $slug);
        $stmt->bindParam(":description", $data['description']);
        $stmt->bindParam(":price", $data['price']);
        $stmt->bindParam(":stock_quantity", $data['stock_quantity']);
        $stmt->bindParam(":image_url", $data['image_url']);
        $stmt->bindParam(":is_featured", $data['is_featured']);
        
        return $stmt->execute();
    }

    public function delete($id) {
        $query = "DELETE FROM " . $this->table_name . " WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":id", $id);
        return $stmt->execute();
    }

    public function getById($id) {
        $query = "SELECT p.*, c.name as category_name 
                  FROM " . $this->table_name . " p
                  LEFT JOIN categories c ON p.category_id = c.id
                  WHERE p.id = :id
                  LIMIT 1";
        
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(":id", $id);
        $stmt->execute();
        
        return $stmt->fetch(\PDO::FETCH_ASSOC);
    }
}
